/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CPUGUI {
    private CPUguiOut outputWindow;
    private JFrame window;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnRun;
    private JButton btnSend;
    private JTextArea txtaRAM;
    private JTextArea txtaINS;
    private JTextField txtInput;
    private JLabel lblARegState;
    private JLabel lblBRegState;
    private JLabel lblMRegState;
    private JLabel lblLRegState;
    private JPanel pnlOptions;
    private JPanel pnlDisplay;
    private JCheckBox cbDebug;
    private JScrollPane scpRam;
    private JScrollPane scpINS;
    private JPanel pnlInput;
    private JProgressBar pbMemFree;
    File file;
    private BufferedReader breader;
    private int i = 0;
    private int p = 0;
    private int inpInt = 0;
    private int RF = 0;
    private String inpStr = "";
    private byte areg = 0;
    private byte breg = 0;
    private byte mreg = 0;
    private byte lreg = 0;
    private boolean btnState;
    public static byte[] ram = new byte[128];

    public void Create(int h, int w) {
        System.out.println(30);
        this.window = new JFrame("CPU emulator 3.3.0 BETA");
        this.pnlOptions = new JPanel();
        this.pnlDisplay = new JPanel();
        this.pnlInput = new JPanel();
        this.outputWindow = new CPUguiOut();
        this.outputWindow.OutputGuiCreate();
        this.btnLoad = new JButton("Load");
        this.btnSave = new JButton("Save");
        this.btnRun = new JButton("Run");
        this.btnSend = new JButton("Send");
        this.btnLoad.addActionListener(new LoadListener());
        this.btnRun.addActionListener(new RunListener());
        this.btnSend.addActionListener(new SendListener());
        this.lblARegState = new JLabel("Register A: 0");
        this.lblBRegState = new JLabel("Register B: 0");
        this.lblMRegState = new JLabel("Register M: 0");
        this.lblLRegState = new JLabel("Register L: 0");
        this.txtaRAM = new JTextArea(16, 10);
        this.txtaINS = new JTextArea(15, 15);
        this.txtInput = new JTextField(25);
        this.cbDebug = new JCheckBox("Debug");
        this.scpINS = new JScrollPane(this.txtaINS);
        this.scpRam = new JScrollPane(this.txtaRAM);
        this.pbMemFree = new JProgressBar(0, ram.length);
        this.txtaRAM.setFont(new Font("Monospaced", 0, 12));
        this.txtaINS.setFont(new Font("Monospaced", 0, 12));
        this.txtaINS.setEditable(false);
        this.txtaRAM.setEditable(false);
        this.pnlOptions.add(this.btnLoad);
        this.pnlOptions.add(this.btnRun);
        this.pnlOptions.add(this.btnSave);
        this.pnlOptions.add(this.cbDebug);
        this.pnlDisplay.setLayout(new BoxLayout(this.pnlDisplay, 1));
        this.pnlDisplay.add(this.lblARegState);
        this.pnlDisplay.add(this.lblBRegState);
        this.pnlDisplay.add(this.lblMRegState);
        this.pnlDisplay.add(this.lblLRegState);
        this.pnlDisplay.add(this.pbMemFree);
        this.pbMemFree.setValue(256);
        this.pbMemFree.setStringPainted(true);
        this.pbMemFree.setString("Memory Free");
        this.pnlDisplay.add(this.scpRam);
        this.pnlInput.add(this.txtInput);
        this.pnlInput.add(this.btnSend);
        this.window.getContentPane().add("North", this.pnlOptions);
        this.window.getContentPane().add("West", this.pnlDisplay);
        this.window.getContentPane().add("South", this.pnlInput);
        this.window.getContentPane().add(this.scpINS);
        this.window.setDefaultCloseOperation(3);
        this.window.setSize(w, h);
        this.window.setVisible(true);
        boolean i = false;
        this.RamUsageUpdate();
    }

    public void UpdateRam() {
        this.p = 0;
        this.txtaRAM.setText("");
        while (this.p <= ram.length - 1) {
            this.txtaRAM.append(String.valueOf(String.format("%04x", this.p).toUpperCase()) + ": " + ram[this.p] + "\n");
            ++this.p;
        }
    }

    public void cpuPerform(String ins, int d, int d2) {
        switch (ins) {
            case "NOP": {
                this.printIns(this.i, "NOP", "000F", d, d2);
                break;
            }
            case "HLT": {
                this.printIns(this.i, "HLT", "0001", d, d2);
                break;
            }
            case "LDA": {
                this.printIns(this.i, "LDA", "0002", d, d2);
                this.areg = ram[d];
                break;
            }
            case "STA": {
                this.printIns(this.i, "STA", "0003", d, d2);
                CPUGUI.ram[d] = this.areg;
                break;
            }
            case "LDB": {
                this.printIns(this.i, "LDB", "0004", d, d2);
                this.breg = ram[d];
                break;
            }
            case "STB": {
                this.printIns(this.i, "STB", "0005", d, d2);
                CPUGUI.ram[d] = this.breg;
                break;
            }
            case "LDM": {
                this.printIns(this.i, "LDM", "0006", d, d2);
                this.mreg = ram[d];
                break;
            }
            case "STM": {
                this.printIns(this.i, "STM", "0007", d, d2);
                CPUGUI.ram[d] = this.mreg;
                break;
            }
            case "ADD": {
                this.mreg = (byte)(this.mreg + this.areg);
                this.printIns(this.i, "ADD", "0008", d, d2);
                break;
            }
            case "SUB": {
                this.mreg = (byte)(this.mreg - this.areg);
                this.printIns(this.i, "SUB", "0009", d, d2);
                break;
            }
            case "DIV": {
                this.mreg = (byte)(this.mreg / this.areg);
                this.printIns(this.i, "DIV", "000A", d, d2);
                break;
            }
            case "MUL": {
                this.mreg = (byte)(this.mreg * this.areg);
                this.printIns(this.i, "MUL", "000B", d, d2);
                break;
            }
            case "DSP": {
                this.printIns(this.i, "DSP", "000C", d, d2);
                this.outputWindow.println(String.valueOf(String.format("%04d", ram[20])) + " 0x" + String.format("%04x", ram[20]).toUpperCase() + " " + String.format("%c", ram[20]));
                this.outputWindow.println(String.valueOf(String.format("%04d", ram[21])) + " 0x" + String.format("%04x", ram[21]).toUpperCase() + " " + String.format("%c", ram[21]));
                this.outputWindow.println(String.valueOf(String.format("%04d", ram[22])) + " 0x" + String.format("%04x", ram[22]).toUpperCase() + " " + String.format("%c", ram[22]));
                this.outputWindow.println(String.valueOf(String.format("%04d", ram[23])) + " 0x" + String.format("%04x", ram[23]).toUpperCase() + " " + String.format("%c", ram[23]));
                break;
            }
            case "INC": {
                this.breg = (byte)(this.breg + 1);
                this.printIns(this.i, "PUT", "000D", d, d2);
                break;
            }
            case "DEC": {
                this.breg = (byte)(this.breg - 1);
                this.printIns(this.i, "DEC", "000E", d, d2);
                break;
            }
            case "PUT": {
                CPUGUI.ram[d2] = (byte)d;
                this.printIns(this.i, "PUT", "000F", d, d2);
                break;
            }
            case "DMP": {
                this.outputWindow.RamDump(ram);
                this.printIns(this.i, "DMP", "0010", d, d2);
                break;
            }
            case "AND": {
                this.printIns(this.i, "AND", "0011", d, d2);
                this.lreg = (byte)(this.lreg & this.areg);
                break;
            }
            case "OR": {
                this.printIns(this.i, "OR ", "0012", d, d2);
                this.lreg = (byte)(this.lreg | this.areg);
                break;
            }
            case "LDL": {
                this.printIns(this.i, "LDL", "0013", d, d2);
                this.lreg = ram[d];
                break;
            }
            case "STL": {
                this.printIns(this.i, "STL", "0014", d, d2);
                CPUGUI.ram[d] = this.lreg;
                break;
            }
            default: {
                this.txtaINS.append("Unknown Command: " + this.txtInput.getText() + "\n");
            }
        }
        this.i += 4;
        this.lblARegState.setText("Register A: " + this.areg);
        this.lblBRegState.setText("Register B: " + this.breg);
        this.lblMRegState.setText("Register M: " + this.mreg);
        this.lblLRegState.setText("Register L: " + this.lreg);
        this.UpdateRam();
        this.RamUsageUpdate();
        if (this.cbDebug.isSelected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void printIns(int i, String Ins, String Opcode, int d1, int d2) {
        String s = String.valueOf(String.format("%04x: ", (short)i).toUpperCase()) + Ins + " " + String.format("%3s", Integer.toString(d1)).replace(" ", "0") + " " + String.format("%3s", Integer.toString(d2)).replace(" ", "0") + " " + Opcode + String.format("%02x", (byte)d1).toUpperCase() + String.format("%02x", (byte)d2).toUpperCase();
        this.txtaINS.append(String.valueOf(s) + System.lineSeparator());
    }

    public void Run(File f) {
        String line = "";
        String[] a = new String[2];
        this.txtaINS.setText("");
        this.i = 0;
        try {
            this.breader = new BufferedReader(new FileReader(f));
            while ((line = this.breader.readLine()) != null) {
                a = line.split(" ");
                System.out.print(String.valueOf(a[0]) + " ");
                System.out.println(a[1]);
                this.cpuPerform(a[0], Integer.parseInt(a[1]), Integer.parseInt(a[2]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean bitCheck(long val, byte place) {
        boolean b = false;
        long av = 2 ^ place;
        if ((val &= av) != 0L) {
            b = true;
        }
        return b;
    }

    public void inpChk() {
        if (this.txtInput.getText() != null) {
            this.inpStr = this.txtInput.getText();
        }
    }

    public void RamUsageUpdate() {
        int i = 0;
        this.RF = 0;
        while (i <= ram.length - 1) {
            if (ram[i] != 0) {
                ++this.RF;
            }
            ++i;
        }
        this.pbMemFree.setString(String.valueOf(ram.length - this.RF) + "/" + ram.length + " BYTES " + String.format("%.2f", this.pbMemFree.getPercentComplete() * 100.0) + "% ");
        this.pbMemFree.setValue(this.RF);
        this.txtaRAM.setCaretPosition(0);
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser("Open A .nrda file");
            fc.showOpenDialog(CPUGUI.this.window);
            CPUGUI.this.file = fc.getSelectedFile();
            if (CPUGUI.this.file != null) {
                System.out.println(CPUGUI.this.file.getAbsolutePath());
            } else {
                System.out.println("File Not Selected, Assigning went wrong or user canceled...");
            }
        }
    }

    private class RunListener
    implements ActionListener {
        private RunListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CPUGUI.this.Run(CPUGUI.this.file);
        }
    }

    public class SendListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String inp = CPUGUI.this.txtInput.getText();
            String[] arg = inp.split(" ");
            CPUGUI.this.cpuPerform(arg[0], Integer.parseInt(arg[1]), Integer.parseInt(arg[2]));
        }
    }
}

