/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CPUGUI {
    JFrame window;
    JButton btnLoad;
    JButton btnSave;
    JButton btnRun;
    JTextArea txtaRAM;
    JTextArea txtaINS;
    JLabel lblARegState;
    JLabel lblBRegState;
    JLabel lblMRegState;
    JPanel pnlOptions;
    JPanel pnlDisplay;
    JCheckBox cbDebug;
    JScrollPane scpRam;
    JScrollPane scpINS;
    File file;
    BufferedReader breader;
    int i = 0;
    int p = 0;
    byte areg = 0;
    byte breg = 0;
    byte mreg = 0;
    byte[] ram = new byte[512];

    public void Create(int h, int w) {
        System.out.println(30);
        this.ram[1] = 1;
        this.ram[2] = 2;
        this.ram[3] = 3;
        this.window = new JFrame("CPU emulator 2.0.0");
        this.pnlOptions = new JPanel();
        this.pnlDisplay = new JPanel();
        this.btnLoad = new JButton("Load");
        this.btnSave = new JButton("Save");
        this.btnRun = new JButton("Run");
        this.btnLoad.addActionListener(new LoadListener());
        this.btnRun.addActionListener(new RunListener());
        this.lblARegState = new JLabel("Register A: 0");
        this.lblBRegState = new JLabel("Register B: 0");
        this.lblMRegState = new JLabel("Register M: 0");
        this.txtaRAM = new JTextArea(16, 10);
        this.txtaINS = new JTextArea(15, 15);
        this.cbDebug = new JCheckBox("Debug");
        this.scpINS = new JScrollPane(this.txtaINS);
        this.scpRam = new JScrollPane(this.txtaRAM);
        this.txtaRAM.setFont(new Font("Monospaced", 0, 12));
        this.txtaINS.setFont(new Font("Monospaced", 0, 12));
        this.txtaINS.setEditable(false);
        this.txtaRAM.setEditable(false);
        this.pnlOptions.add(this.btnLoad);
        this.pnlOptions.add(this.btnRun);
        this.pnlOptions.add(this.btnSave);
        this.pnlOptions.add(this.cbDebug);
        this.pnlDisplay.setLayout(new BoxLayout(this.pnlDisplay, 1));
        this.pnlDisplay.add(this.lblARegState);
        this.pnlDisplay.add(this.lblBRegState);
        this.pnlDisplay.add(this.lblMRegState);
        this.pnlDisplay.add(this.scpRam);
        this.window.getContentPane().add("North", this.pnlOptions);
        this.window.getContentPane().add("West", this.pnlDisplay);
        this.window.getContentPane().add(this.scpINS);
        this.window.setDefaultCloseOperation(3);
        this.window.setSize(w, h);
        this.window.setVisible(true);
    }

    public void cpuPerform(String ins, int d) {
        switch (ins) {
            case "NOP": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": NOP" + "\n");
                ++this.i;
                break;
            }
            case "HLT": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": HLT" + "\n");
                ++this.i;
                break;
            }
            case "LDA": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": LDA " + Integer.toHexString(d).toUpperCase() + "\n");
                this.areg = this.ram[d];
                this.i += 2;
                break;
            }
            case "STA": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": STA " + Integer.toHexString(d).toUpperCase() + "\n");
                this.ram[d] = this.areg;
                this.i += 2;
                break;
            }
            case "LDB": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": LDA " + Integer.toHexString(d).toUpperCase() + "\n");
                this.breg = this.ram[d];
                this.i += 2;
                break;
            }
            case "STB": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": STB " + Integer.toHexString(d).toUpperCase() + "\n");
                this.ram[d] = this.breg;
                this.i += 2;
                break;
            }
            case "LDM": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": LDM " + Integer.toHexString(d).toUpperCase() + "\n");
                this.mreg = this.ram[d];
                this.i += 2;
                break;
            }
            case "STM": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": STM " + Integer.toHexString(d).toUpperCase() + "\n");
                this.ram[d] = this.mreg;
                this.i += 2;
                break;
            }
            case "ADD": {
                this.mreg = (byte)(this.mreg + this.areg);
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": ADD" + "\n");
                ++this.i;
                break;
            }
            case "SUB": {
                this.mreg = (byte)(this.mreg - this.areg);
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": SUB" + "\n");
                ++this.i;
                break;
            }
            case "DIV": {
                this.mreg = (byte)(this.mreg / this.areg);
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": DIV" + "\n");
                ++this.i;
                break;
            }
            case "DSP": {
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": DSP " + this.ram[11] + "|" + this.ram[12] + "|" + this.ram[13] + "|" + this.ram[14] + "|" + this.ram[15] + "|" + this.ram[16] + "|" + this.ram[17] + "|" + this.ram[18] + "|" + this.ram[19] + "\n");
                ++this.i;
                break;
            }
            case "INC": {
                this.breg = (byte)(this.breg + 1);
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": INC" + "\n");
                ++this.i;
                break;
            }
            case "DEC": {
                this.breg = (byte)(this.breg + 1);
                this.txtaINS.append(String.valueOf(String.format("%04x", this.i).toUpperCase()) + ": DEC" + "\n");
                ++this.i;
            }
        }
        this.lblARegState.setText("Register A: " + this.areg);
        this.lblBRegState.setText("Register B: " + this.breg);
        this.lblMRegState.setText("Register M: " + this.mreg);
        this.p = 0;
        this.txtaRAM.setText("");
        while (this.p <= this.ram.length - 1) {
            this.txtaRAM.append(String.valueOf(String.format("%04x", this.p).toUpperCase()) + ": " + this.ram[this.p] + "\n");
            ++this.p;
        }
        try {
            Thread.sleep(0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void Run(File f) {
        String line = "";
        String[] a = new String[2];
        this.txtaINS.setText("");
        this.i = 0;
        try {
            this.breader = new BufferedReader(new FileReader(f));
            while ((line = this.breader.readLine()) != null) {
                a = line.split(" ");
                System.out.print(String.valueOf(a[0]) + " ");
                System.out.println(a[1]);
                this.cpuPerform(a[0], Integer.parseInt(a[1]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser("Open A .nrda file");
            fc.showOpenDialog(CPUGUI.this.window);
            CPUGUI.this.file = fc.getSelectedFile();
            if (CPUGUI.this.file != null) {
                System.out.println(CPUGUI.this.file.getAbsolutePath());
            } else {
                System.out.println("File Not Selected, Assigning went wrong or user canceled...");
            }
        }
    }

    private class RunListener
    implements ActionListener {
        private RunListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CPUGUI.this.Run(CPUGUI.this.file);
        }
    }
}

