import java.io.*;
import javax.sound.midi.*;
import java.util.*;

import javax.swing.JFileChooser;
public class CPUMain {

	public static void main(String[] args) {
		// TODO Auto-generated method stub
			System.out.println("NERD16 CPU Emulator 1.2.0");
			AudioSynth as = new AudioSynth();
			//as.getSynths();
			ShortMessage msg = as.getShortMessage((byte) 0,(byte) 0,(byte) 60);
			as.Play(msg);
			try
			{
				Thread.sleep(10);
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			as.Stop((byte)0);

			@SuppressWarnings("unused")
			int prl = 256;
			int drl = 8;
			String dbg = "0";
			byte[] ram = new byte[2048];
			byte[] tram = new byte[drl];
			System.out.println((ram.length)+" Bytes Free...");
			Scanner sc = new Scanner(System.in);
			ram[0] = 0;
			ram[1] = 1;
			ram[2] = 2;
			ram[3] = 3;
			ram[4] = 4;
			ram[5] = 5;
			ram[6] = 6;
			ram[7] = 7;
			ram[8] = 8;
			ram[9] = 9;
			byte areg = 0;
			byte breg = 0;
			byte mreg = 0;
			int i = 0;
			int addr;
			try
			{
				System.out.print("Debug: ");
				dbg = sc.nextLine();
				File fo = new File(sc.nextLine());
				FileReader reader = new FileReader(fo);
				BufferedReader breader = new BufferedReader(reader);
				String line = null;
				Boolean hlted = false;
				while(((line = breader.readLine()) != null))
				{
					addr = -1;
					if(!hlted)
					{
						System.out.print("0x"+Integer.toHexString(i)+": "+line+" ");
						
						switch(line)
						{
						// Do Nothing If the line is 0
						case "0":
							System.out.println("NOP");
							i += 1;
							break;
						// Print HLT and stop
						case "1":
							System.out.println("HLT");
							i += 1;
							hlted = true;
							break;
						// Load a given ram address into register A 	
						case "2":
							addr = Integer.parseInt(breader.readLine(),16);
							System.out.println("LDA "+addr);
							areg = ram[addr-prl];
							i += 2;
							break;
						// Store the value of register A into ram	
						case "3":
							addr = Integer.parseInt(breader.readLine(),16);
							System.out.println("STA "+addr);
							ram[addr-prl] = areg;
							i += 2;
							break;
						// Load a given ram address into Register B	
						case "4":
							addr = Integer.parseInt(breader.readLine(),16);
							System.out.println("LDB "+addr);
							breg = ram[addr-prl];
							i += 2;
							break;
						// Store the value of register B into ram	
						case "5":
							addr = Integer.parseInt(breader.readLine(),16);
							
							System.out.println("STB "+addr);
							
							
							ram[addr-prl] = breg;
							
							i += 2;
							break;
						// Load a given ram address into register M 	
						case "6":
							addr = Integer.parseInt(breader.readLine(),16);
							System.out.println("LDM "+addr);
							mreg = ram[addr-prl];
							
							i += 2;
							break;
						// Store the value of register M into ram		
						case "7":
							addr = Integer.parseInt(breader.readLine(),16);
							System.out.println("STM "+addr);
							ram[addr-prl] = mreg;
							
							i += 2;
							break;
						// Add Register M to Register A, Store the result in Register M	
						case "8":
							System.out.println("ADD");
							mreg += areg;
							i += 1;
							break;
						// M = M - A	
						case "9":
							System.out.println("SUB");
							mreg -= areg;
							i += 1;
							break;
						// M = M / A	
						case "A":
							System.out.println("DIV");
							mreg /= areg;
							i += 1;
							break;
						// M = M * A	
						case "B":
							System.out.println("MUL");
							mreg *= areg;
							i += 1;
							break;
						// Swap Reg A with Reg B 	
						case "C":
							System.out.println("Swapping A ("+areg+") and B ("+breg+")");
							byte t = 0;
							t = areg;
							areg = breg;
							breg = t;
							i += 1;
							break;
						// print the first 8 Bytes of work ram	
						case "D":
							System.out.print("DSP ");
							System.out.print(ram[0]+"|");
							System.out.print(ram[1]+"|");
							System.out.print(ram[2]+"|");
							System.out.print(ram[3]+"|");
							System.out.print(ram[4]+"|");
							System.out.print(ram[5]+"|");
							System.out.print(ram[6]+"|");
							System.out.println(ram[7]);
							
							i += 1;
							break;
						// Increment Reg B	
						case "E":
							System.out.println("INC");
							breg += 1;
							i += 1;
							break;
						// Decrement Reg B	
						case "F":
							System.out.println("DEC");
							breg -= 1;
							i += 1;
							
							
						}
						
						
						ShortMessage V1 = as.getShortMessage((byte) 0, (byte) 0, ram[2037]);
						ShortMessage V2 = as.getShortMessage((byte) 0, (byte) 1, ram[2038]);
						ShortMessage V3 = as.getShortMessage((byte) 0, (byte) 2, ram[2039]);
						ShortMessage V4 = as.getShortMessage((byte) 0, (byte) 3, ram[2040]);
						
						as.Play(V1);
						as.Play(V2);
						as.Play(V3);
						as.Play(V4);
						
						if(dbg != "0")
						{
							System.out.println("A: "+areg);
							System.out.println("B: "+breg);
							System.out.println("M: "+mreg);
						}
						
						
						
					}
				}
				breader.close();
				
				System.out.println("------------------RAM DUMP------------------");
				int z = 0;
				while(z <= ram.length-1)
				{
					System.out.println(z+": "+ram[z]);
					z += 1;
				}
				
				System.out.print("Press Enter To Quit...");
				sc.nextLine();
			} catch(Exception ex) {
				System.out.println(ex);
			}
			
			
	}
	

}
