import java.util.Vector;

import javax.sound.*;
import javax.sound.midi.*;

public class AudioSynth {
	private byte MCV1 = 0;
	private byte MCV2 = 0;
	private byte MCV3 = 0;
	private byte MCV4 = 0;
	private byte[] DATA = new byte[8];
	// Obtain information about all the installed synthesizers.
	Vector synthInfos;
	MidiDevice device;
	
	
	MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
	
	public void getSynths(){
	for (int i = 0; i < infos.length; i++) {
	    try {
	        device = MidiSystem.getMidiDevice(infos[i]);
	        System.out.println("["+i+"]: "+device);
	    } catch (MidiUnavailableException e) {
	          // Handle or throw exception...
	    }
	    }
	}
	
	public void Play(ShortMessage sm)
	{
		try
		{
			Receiver rc = MidiSystem.getReceiver();
			rc.send(sm, -1);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
		 

	
	public ShortMessage getShortMessage(byte mc, byte d1, byte d2)
	{
		try
		{
			ShortMessage msg = new ShortMessage(ShortMessage.NOTE_ON, (byte) d1,(byte) d2, 127);
			return msg;
		} catch (Exception ex)
		{
			ex.printStackTrace();
			return null;
		}
		
		}
	

	public void Stop(byte ch)
	{
		try
		{
			Receiver rc = MidiSystem.getReceiver();
			ShortMessage msg = new ShortMessage(ShortMessage.NOTE_OFF);
			rc.send(msg, -1);
		} catch (Exception ex)
		{
			
		}
	}
	
}


